﻿////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// SimpleNdefParser Class and Test
//
// This classes and Tests are released under by MIT License
//
// Copyright 2019 Office-Fun.com(M.Sonobe)
//
// https://opensource.org/licenses/mit-license.php
// 
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;


namespace NdefParser
{
    [TestClass]
    public class UnitTest1_単体テスト
    {
        // URI Record Type Definition At Page9
        readonly byte[] sample1
            = new byte[] { 0xD1, 0x01, 0x08, 0x55, 0x01, 0x6e, 0x66, 0x63, 0x2e, 0x63, 0x6f, 0x6d };

        readonly byte[] sample2
            = new byte[] { 0xD1, 0x01, 0x0D, 0x55, 0x05, 0x2b, 0x33, 0x35, 0x38, 0x39, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37 };

        readonly byte[] sample3
            = new byte[] { 0xD1, 0x01, 0x1F, 0x55, 0x00, 0x6d, 0x6d, 0x73, 0x3a, 0x2f, 0x2f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x77, 0x6d, 0x76, };

        /// <summary>
        /// NXP213に書き込んだ実例より　Ndef Messageの例　LockControl
        /// </summary>
        readonly byte[] sample4_MyType2Tag
            = new byte[] { 0x01, 0x03, 0xA0, 0xC0, 0x34, 0x03, 0x1B, 0xD1, 0x01, 0x17, 0x55, 0x00, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3A, 0x2F, 0x2F, 0x6F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x2D, 0x66, 0x75, 0x6E, 0x2E, 0x63, 0x6F, 0x6D, 0xFE };

        readonly byte[] sample4_MyType2Tag_dash
            = new byte[] { 0xD1, 0x01, 0x17, 0x55, 0x00, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3A, 0x2F, 0x2F, 0x6F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x2D, 0x66, 0x75, 0x6E, 0x2E, 0x63, 0x6F, 0x6D };


        /// <summary>
        /// Qiita 「NDEFについて理解する」を参照 　Ndef Messageの例　Message TLVの例
        /// </summary>
        readonly byte[] sample5_qiita
            = new byte[] { 0x03, 0x0f,0xD1, 0x01,0x0B, 0x55, 0x03, 0x71,0x69,0x69, 0x74,0x61,0x2e,0x63, 0x6f,0x6d, 0x2f, 0xfe};

        readonly byte[] sample5_qiita_dash
            = new byte[] { 0xD1, 0x01, 0x0B, 0x55, 0x03, 0x71, 0x69, 0x69, 0x74, 0x61, 0x2e, 0x63, 0x6f, 0x6d, 0x2f };

        //// TEXTの例
        //// https://www.slideshare.net/tomorrowkey/ndef-13784268
        //readonly byte[] sample6_slideshare
        //    = new byte[] { 0xD1, 0x01, 0x10, 0x54, 0x02, 0x65, 0x6E, 0x48, 0x65, 0x6C, 0x6C, 0x6F, 0x2C, 0x20, 0x57, 0x6F, 0x72,0x6C,0x64,0x2E };

        // page 6.  Table 4. Example: “Hello, world!” も参考になります。テキストを採用する際は、これも例に入れること。


        [TestMethod]
        public void Bit演算01_Get()
        {
            Assert.IsTrue(  NdefUtility.GetBit(0x01, 0) ,"ビット演算関数が間違っています");
            Assert.IsFalse( NdefUtility.GetBit(0x01, 1) ,"ビット演算関数が間違っています");

            Assert.IsTrue(  NdefUtility.GetBit(0x03, 0) ,"ビット演算関数が間違っています");

            Assert.IsTrue(  NdefUtility.GetBit(0x02, 1) ,"ビット演算関数が間違っています");
            Assert.IsFalse( NdefUtility.GetBit(0x02, 2) ,"ビット演算関数が間違っています");
        }

        [TestMethod]
        public void Bit演算02_GetRange()
        {
            Assert.AreEqual(1, NdefUtility.GetBitRange_From_2_0(0x01), "下位3桁を取り出す関数が間違っています");
            Assert.AreEqual(2, NdefUtility.GetBitRange_From_2_0(0x02), "下位3桁を取り出す関数が間違っています");
            Assert.AreEqual(3, NdefUtility.GetBitRange_From_2_0(0x03), "下位3桁を取り出す関数が間違っています");
            Assert.AreEqual(4, NdefUtility.GetBitRange_From_2_0(0x04), "下位3桁を取り出す関数が間違っています");
            Assert.AreEqual(5, NdefUtility.GetBitRange_From_2_0(0x05), "下位3桁を取り出す関数が間違っています");
            Assert.AreEqual(6, NdefUtility.GetBitRange_From_2_0(0x06), "下位3桁を取り出す関数が間違っています");
            Assert.AreEqual(7, NdefUtility.GetBitRange_From_2_0(0x07), "下位3桁を取り出す関数が間違っています");
            Assert.AreEqual(0, NdefUtility.GetBitRange_From_2_0(0x08), "下位3桁を取り出す関数が間違っています");
            Assert.AreEqual(1, NdefUtility.GetBitRange_From_2_0(0x09), "下位3桁を取り出す関数が間違っています");
        }

        [TestMethod]
        public void Bit演算03_Set()
        {
            Assert.AreEqual(3,  NdefUtility.SetBit(0x02, 0) ,"ビット演算・設定が間違っています");
            Assert.AreEqual(6,  NdefUtility.SetBit(0x04, 1) , "ビット演算・設定が間違っています");
            Assert.AreEqual(12, NdefUtility.SetBit(0x08, 2), "ビット演算・設定が間違っています");
            Assert.AreEqual(24, NdefUtility.SetBit(0x10, 3), "ビット演算・設定が間違っています");

            Assert.AreEqual( 7, NdefUtility.SetBitRangeFrom_2_0(0x00, 7), "ビット演算・設定が間違っています");
        }

        [TestMethod]
        public void Bit演算04_GetRangeLower()
        {
            Assert.AreEqual(0x01, NdefUtility.GetBitRange_Lower4bit(0x01), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x02, NdefUtility.GetBitRange_Lower4bit(0x02), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x03, NdefUtility.GetBitRange_Lower4bit(0x03), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x04, NdefUtility.GetBitRange_Lower4bit(0x04), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x05, NdefUtility.GetBitRange_Lower4bit(0x05), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x06, NdefUtility.GetBitRange_Lower4bit(0x06), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x07, NdefUtility.GetBitRange_Lower4bit(0x07), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x08, NdefUtility.GetBitRange_Lower4bit(0x08), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x09, NdefUtility.GetBitRange_Lower4bit(0x09), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x0A, NdefUtility.GetBitRange_Lower4bit(0x0A), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x0B, NdefUtility.GetBitRange_Lower4bit(0x0B), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x0C, NdefUtility.GetBitRange_Lower4bit(0x0C), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x0D, NdefUtility.GetBitRange_Lower4bit(0x0D), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x0E, NdefUtility.GetBitRange_Lower4bit(0x0E), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x0F, NdefUtility.GetBitRange_Lower4bit(0x0F), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x00, NdefUtility.GetBitRange_Lower4bit(0x00), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x00, NdefUtility.GetBitRange_Lower4bit(0x10), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x03, NdefUtility.GetBitRange_Lower4bit(0x23), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x03, NdefUtility.GetBitRange_Lower4bit(0x43), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x03, NdefUtility.GetBitRange_Lower4bit(0xF3), "下位4桁を取り出す関数が間違っています");

        }

        [TestMethod]
        public void Bit演算05_GetRangeUpper()
        {
            Assert.AreEqual(0x01, NdefUtility.GetBitRange_Upper4bit(0x11), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x03, NdefUtility.GetBitRange_Upper4bit(0x32), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x02, NdefUtility.GetBitRange_Upper4bit(0x23), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x05, NdefUtility.GetBitRange_Upper4bit(0x54), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x06, NdefUtility.GetBitRange_Upper4bit(0x65), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x05, NdefUtility.GetBitRange_Upper4bit(0x56), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x06, NdefUtility.GetBitRange_Upper4bit(0x67), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x08, NdefUtility.GetBitRange_Upper4bit(0x88), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x09, NdefUtility.GetBitRange_Upper4bit(0x90), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x0A, NdefUtility.GetBitRange_Upper4bit(0xA1), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x0B, NdefUtility.GetBitRange_Upper4bit(0xB2), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x0C, NdefUtility.GetBitRange_Upper4bit(0xC3), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x0D, NdefUtility.GetBitRange_Upper4bit(0xD4), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x0E, NdefUtility.GetBitRange_Upper4bit(0xE5), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x0F, NdefUtility.GetBitRange_Upper4bit(0xF6), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x00, NdefUtility.GetBitRange_Upper4bit(0x00), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x01, NdefUtility.GetBitRange_Upper4bit(0x10), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x02, NdefUtility.GetBitRange_Upper4bit(0x23), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x04, NdefUtility.GetBitRange_Upper4bit(0x43), "下位4桁を取り出す関数が間違っています");
            Assert.AreEqual(0x0F, NdefUtility.GetBitRange_Upper4bit(0xF3), "下位4桁を取り出す関数が間違っています");

        }


        [TestMethod]
        public void IdentifierCodeテスト()
        {
            for (byte i = 1; i < (byte)UriIdentifierCode.Urn_nfc; ++i)
            {
                string str = NdefUtility.GetUriIdentifierCodeString(i);

                UriIdentifierCode uriIdentifier = NdefUtility.GetUriIdentifierCode(str);

                Assert.AreEqual(i, (byte)uriIdentifier, i.ToString() +"番目でエラーが発生しました。");
            }
        }
    }



}
